/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.logon;

import com.ibm.hwmca.base.logon.ChangeHMCPasswordBean;
import com.ibm.hwmca.base.logon.ConfirmCancelBean;
import com.ibm.hwmca.base.logon.LogonBean;
import com.ibm.hwmca.base.logon.LogonConstants;
import com.ibm.hwmca.base.logon.LogonErrorIds;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.logon.LogonValidation;
import com.ibm.hwmca.fw.managed.HWMessagesExistProperty;
import com.ibm.hwmca.fw.managed.OSMessagesExistProperty;
import com.ibm.hwmca.fw.managed.StatusProperty;
import com.ibm.hwmca.fw.managed.User;
import com.ibm.hwmca.fw.shutdown.ShutdownInProcessException;
import com.ibm.hwmca.fw.shutdown.ShutdownManager;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.TaskActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class LogonTasklet
extends PanelTasklet
implements LogonConstants,
LogonErrorIds,
PropertyChangeListener {
    private static final String TRACE_MASKT = "XLGNTSKT";
    private static final String TRACE_MASKF = "XLGNTSKF";
    private static final String TRACE_MASKD = "XLGNTSKD";
    private static final String LOGON_MESSAGES_FILENAME = "com.ibm.hwmca.base.res.message";
    private static final String AUIML_FILE_NAME = "com.ibm.hwmca.base.logon.res.LogonRes";
    private StatusProperty statusProperty;
    private HWMessagesExistProperty hwMessagesExistProperty;
    private OSMessagesExistProperty osMessagesExistProperty;
    private boolean logonIsLocal;
    private String userid;
    private Long time;

    public LogonTasklet() {
        Trace.trace(TRACE_MASKT, "<> LogonTasklet.LogonTasklet()");
    }

    public void init() {
        Trace.trace(TRACE_MASKT, "<> LogonTasklet.init()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> LogonTasklet.service(" + request + ", " + response + ")");
        if (request.isInitialRequest()) {
            LogonBean logonBean = new LogonBean();
            logonBean.setBeanName("HMCLogonPanel");
            response.replace(AUIML_FILE_NAME, "HMCLogonPanel", logonBean);
        } else {
            String source = (String)request.getData("SOURCE");
            if (source.equals("HMCLogonPanel")) {
                this.serviceLogon(request, response);
            } else if (source.equals("ChangeHMCPasswordPanel")) {
                this.servicePassword(request, response);
            } else if (source.equals("ConfirmCancelPanel")) {
                this.serviceShutdown(request, response);
            } else if (source.equals("PREPARE")) {
                this.statusProperty = StatusProperty.getStatusProperty();
                this.statusProperty.addStatusPropertyListener(this, true);
                this.hwMessagesExistProperty = HWMessagesExistProperty.getHWMessagesExistProperty();
                this.hwMessagesExistProperty.addHWMessagesExistPropertyListener(this, true);
                this.osMessagesExistProperty = OSMessagesExistProperty.getOSMessagesExistProperty();
                this.osMessagesExistProperty.addOSMessagesExistPropertyListener(this, true);
                response.noAction();
            } else if (source.equals("PROPERTY_CHANGE")) {
                LogonTasklet logonTasklet = this;
                synchronized (logonTasklet) {
                    response.update(request);
                }
            } else if (source.equals("CLEAR")) {
                response.update(request);
            }
        }
        Trace.trace(TRACE_MASKT, "<- LogonTasklet.service()");
    }

    public void serviceLogon(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> LogonTasklet.serviceLogon(" + request + ", " + response + ")");
        TaskActionEvent event = (TaskActionEvent)request.getData("EVENT");
        String elementName = event.getElementName();
        Boolean closedPlatform = (Boolean)request.getData("PLATFORM");
        this.logonIsLocal = closedPlatform;
        this.userid = (String)request.getData("USERID");
        User user = User.getUser(this.userid);
        if (elementName.equals("LogonButton")) {
            LogonValidation.GATE_KEEPER.recordSuccessfulLogonAttempt(this.userid);
            if (this.logonIsLocal) {
                this.statusProperty.removeStatusPropertyListener(this);
                this.hwMessagesExistProperty.removeHWMessagesExistPropertyListener(this);
                this.osMessagesExistProperty.removeOSMessagesExistPropertyListener(this);
            }
            response.terminate();
        } else if (elementName.equals("ChangePasswordButton")) {
            ChangeHMCPasswordBean passwordBean = new ChangeHMCPasswordBean();
            passwordBean.setBeanName("ChangeHMCPasswordPanel");
            passwordBean.setStrictRulesToggle(user.isPasswordRulesEnforced());
            response.openModalChild(AUIML_FILE_NAME, "ChangeHMCPasswordPanel", passwordBean);
        } else if (elementName.equals("ShutdownCancelButton") || elementName.equals("CancelButton")) {
            if (this.logonIsLocal) {
                ConfirmCancelBean shutdownBean = new ConfirmCancelBean();
                shutdownBean.setBeanName("ConfirmCancelPanel");
                response.openModalChild(AUIML_FILE_NAME, "ConfirmCancelPanel", shutdownBean);
            } else {
                response.terminate();
            }
        }
        Trace.trace(TRACE_MASKT, "<- LogonTasklet.serviceLogon()");
    }

    private void servicePassword(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> LogonTasklet.servicePassword(" + request + ", " + response + ")");
        TaskActionEvent event = (TaskActionEvent)request.getData("EVENT");
        String elementName = event.getElementName();
        if (elementName.equals("ChangePasswordButton")) {
            String newPassword = (String)request.getData("PASSWORD");
            User user = User.getUser(this.userid);
            if (user.isPasswordValid(newPassword)) {
                this.showMessageBox(true, new LocalizableText(LOGON_MESSAGES_FILENAME, "LGN.PASSWORD.CHANGE.FAILED.TITLE"), new MessageText(LOGON_MESSAGES_FILENAME, "LGN.LOGON.FAILED.TEXT"), null, null);
                response.noAction();
            } else {
                user.setPassword(newPassword);
                LogonValidation.GATE_KEEPER.recordSuccessfulLogonAttempt(this.userid);
                if (this.logonIsLocal) {
                    this.statusProperty.removeStatusPropertyListener(this);
                    this.hwMessagesExistProperty.removeHWMessagesExistPropertyListener(this);
                    this.osMessagesExistProperty.removeOSMessagesExistPropertyListener(this);
                }
                this.showMessageBox(true, new LocalizableText(LOGON_MESSAGES_FILENAME, "LGN.PASSWORD.CHANGE.SUCCESSFUL.TITLE"), new MessageText(LOGON_MESSAGES_FILENAME, "LGN.PASSWORD.CHANGE.SUCCESSFUL.TEXT"), null, null);
                response.terminate();
            }
        } else if (elementName.equals("CancelButton")) {
            PanelTaskletRequest panelTaskletRequest = new PanelTaskletRequest();
            panelTaskletRequest.setData("SOURCE", "CLEAR");
            this.postRequest("HMCLogonPanel", panelTaskletRequest);
            response.dispose();
        }
        Trace.trace(TRACE_MASKT, "<- LogonTasklet.servicePassword()");
    }

    public void serviceShutdown(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> LogonTasklet.serviceShutdown(" + request + ", " + response + ")");
        TaskActionEvent event = (TaskActionEvent)request.getData("EVENT");
        String elementName = event.getElementName();
        if (elementName.equals("OkButton")) {
            String shutdownChoice = (String)request.getData("ConsoleChoice");
            this.statusProperty.removeStatusPropertyListener(this);
            this.hwMessagesExistProperty.removeHWMessagesExistPropertyListener(this);
            this.osMessagesExistProperty.removeOSMessagesExistPropertyListener(this);
            try {
                if (shutdownChoice.equals("RestartApplicationItem")) {
                    Trace.trace(TRACE_MASKF, "LogonTasklet.serviceShutdown(): Restart Application selected.");
                    ShutdownManager.restartApplication(new LocalizableText("Logon"), null, null);
                } else if (shutdownChoice.equals("RestartConsoleItem")) {
                    Trace.trace(TRACE_MASKF, "LogonTasklet.serviceShutdown(): Restart Console selected.");
                    ShutdownManager.restartConsole(new LocalizableText("Logon"), null, null);
                } else if (shutdownChoice.equals("ShutdownConsoleItem")) {
                    Trace.trace(TRACE_MASKF, "LogonTasklet.serviceShutdown(): Shutdown Console selected.");
                    ShutdownManager.shutdownConsole(new LocalizableText("Logon"), null, null);
                } else if (shutdownChoice.equals("PowerOffConsoleItem")) {
                    Trace.trace(TRACE_MASKF, "LogonTasklet.serviceShutdown(): Power off Console selected.");
                    ShutdownManager.poweroffConsole(new LocalizableText("Logon"), null, null);
                }
            }
            catch (ShutdownInProcessException exc) {
                Trace.trace(TRACE_MASKF, exc);
            }
            response.terminate();
        } else if (elementName.equals("CancelButton")) {
            response.dispose();
        }
        Trace.trace(TRACE_MASKT, "<- LogonTasklet.serviceShutdown()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent event) {
        Trace.trace(TRACE_MASKT, "-> LogonTasklet.propertyChange(" + event + ")");
        LogonTasklet logonTasklet = this;
        synchronized (logonTasklet) {
            try {
                String propertyName = event.getPropertyName();
                Boolean newValue = (Boolean)event.getNewValue();
                this.time = new Long(System.currentTimeMillis());
                PanelTaskletRequest panelTaskletRequest = new PanelTaskletRequest(this.time);
                panelTaskletRequest.setData("SOURCE", "PROPERTY_CHANGE");
                panelTaskletRequest.setData("PROPERTY_NAME", propertyName);
                panelTaskletRequest.setData("NEW_VALUE", newValue);
                this.postRequest("HMCLogonPanel", panelTaskletRequest);
            }
            catch (TaskletException exc) {
                Trace.trace(TRACE_MASKF, exc);
            }
        }
        Trace.trace(TRACE_MASKT, "<- LogonTasklet.propertyChange()");
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> LogonTasklet.logException(" + throwable + ")");
        new FrameworkLog(LogonErrorIds.LOGINFO, 100, throwable).log();
        Trace.trace(TRACE_MASKT, "<- LogonTasklet.logException()");
    }
}

